﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.UpdateClinic
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class ConnectToCrmStep : FilterBase<UpdateClinicStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(UpdateClinicStateObject state)
        {
            try
            {
                if(state == null || state.RequestMessage == null || string.IsNullOrWhiteSpace(state.RequestMessage.OrganizationName))
                    throw new ArgumentNullException("state.RequestMessage.OrganizationName", $"The Organization in the request object or the Request is null/Invalid {state?.RequestMessage?.OrganizationName}");
                else
                    state.OrganizationServiceProxy = PipelineUtilities.ConnectToCrm(state.RequestMessage.OrganizationName, PipelineUtilities.CrmAuthenticationMode.Ad);
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Update Clinic ConnectToCrmStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}